{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 13.08.98 - 21:14:53 $                                        =}
{========================================================================}
unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  MMObj, MMDSPObj, MMWavIn, MMDsWvIn, MMConect, MMDIBCv, MMSpectr, MMHook,
  MMDesign, StdCtrls, MMDSCapt, MMLEDS, MMSystem, MMWave, MMWPlay, MMWavOut,
  MMRingBf;

type
  TForm1 = class(TForm)
    DSWaveIn: TMMDSWaveIn;
    MMSpectrum1: TMMSpectrum;
    MMConnector1: TMMConnector;
    StartBtn: TButton;
    StopBtn: TButton;
    MMDesigner1: TMMDesigner;
    WaveFile: TMMWaveFile;
    PlayBtn: TButton;
    Player: TMMWavePlayer;
    PauseBtn: TButton;
    procedure StartBtnClick(Sender: TObject);
    procedure StopBtnClick(Sender: TObject);
    procedure PlayBtnClick(Sender: TObject);
    procedure PauseBtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.StartBtnClick(Sender: TObject);
begin
  with DSWaveIn do
  if wisPause in State then Restart else Start;
end;

procedure TForm1.PauseBtnClick(Sender: TObject);
begin
  DSWaveIn.Pause;
end;

procedure TForm1.StopBtnClick(Sender: TObject);
begin
  DSWaveIn.Stop;
end;

procedure TForm1.PlayBtnClick(Sender: TObject);
begin
  if wosPlay in Player.State then
  begin
    Player.Stop;
    exit;
  end;
  DSWaveIn.Stop;
  DSWaveIn.Close;
  Player.FileName := WaveFile.Wave.FileName;
  Player.Play;
end;

end.
